import os
import json
from prompta.core.alphabet.skills import Skill


SKILL_SUBDIR = "skills"

class SkillManager:

    def __init__(self, whole_cfg):
        self.whole_cfg = whole_cfg
        print(whole_cfg.experiment.ckpt_dir)
        self.skill_dir = os.path.join(whole_cfg.experiment.ckpt_dir, SKILL_SUBDIR)
        if not os.path.exists(self.skill_dir):
            os.mkdir(self.skill_dir)
            self.skills = {}
        else:
            self.load_checkpoint()

    def load_checkpoint(self):
        skills = os.listdir(self.skill_dir)
        self.skills = {}
        for skill in skills:
            skill_name = skill.split(os.path.sep)[-1].split(".")[0]
            skill_path = os.path.join(self.skill_dir, skill)
            self.skills[skill_name] = Skill(skill_name, skill_path)

    def add_skill(self, skill_name, code):
        with open(os.path.join(self.skill_dir, f"{skill_name}.js"), "w") as f:
            f.write(code)
        self.skills[skill_name] = code

    def __contains__(self, skill_name):
        return skill_name in self.skills
